<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Log;
use App\Models\BannerImage;
use App\Models\DeliveryFeeMaster;
use App\Models\Notification;
use App\Models\User;
use App\Models\Product;
use App\Models\Category;
use App\Models\Courier;
use App\Models\OrderDetails;


class AdminController extends Controller
{

    public function login()
    {
        return view('admin.login');
    }

    public function forgot_password()
    {
        return view('admin.forgot_password');
    }

    public function create_password($email)
    {
        return view('admin.create_password', compact('email'));

    }
    public function user_create_password($email, $id)
    {
        return view('admin.user_create_password', compact('email', 'id'));

    }
    public function sucess_password()
    {
        return view('admin.sucess_password');

    }



    public function profile()
    {
        $user = auth()->user();
        Log::info($user);
        return view('admin.profile', compact('user'));
    }

    // public function user_management()
    // {
    //     $users = User::with('addresses')->get();
    //     return view('admin.user_management', compact('users'));
    // }

    public function user_management()
    {
        $users = User::with('addresses')->where('role', 'user')->get();
        return view('admin.user_management', compact('users'));
    }

    public function delivery_fee()
    {
        $deliveries = DeliveryFeeMaster::all();
        return view('admin.delivery_fee', compact('deliveries'));
    }

    public function category()
    {
        $categories = Category::with('deliveryFeeMaster')->get();
        return view('admin.category', compact('categories'));
    }


    public function add_category()
    {
        $towns = DeliveryFeeMaster::all();
        $categories = Category::where('category_type', 1)->get();
        return view('admin.add_category', compact('towns', 'categories'));

    }


    public function products()
    {
        $products = Product::with(['variants', 'category'])->get();
        return view('admin.products', compact('products'));
    }


    
    public function add_product()
    {

        $categories = Category::all();
        return view('admin.add_product', compact('categories'));

    }


    public function view_product($id)
    {
        $product = Product::with(['variants'])->findOrFail($id);
        $categories = Category::all();
        return view('admin.view_product', compact('product', 'categories'));
    }


    
    public function banner()
    {
        $banners = BannerImage::all();
        return view('admin.banner', compact('banners'));
    }
    public function reset_password()
    {
        return view('admin.reset_password');
    }
    public function notification()
    {

        $notifications = Notification::all();
        return view('admin.notification', compact('notifications'));
    }

    public function recent_orders()
    {
        $recent_orders = OrderDetails::where('status', 'pending')->get();
        return view('admin.recent_orders', compact('recent_orders'));
    }



    public function view_orders($id)
    {

        $recent_orders = OrderDetails::with(['product.category', 'product.subcategory'])
            ->where('user_id', $id)
            ->latest()
            ->get();

        return view('admin.view_orders', compact('recent_orders'));
    }

    public function accepted_orders()
    {
        $recent_orders = OrderDetails::where('status', 'accepted')->get();
        return view('admin.accepted_orders', compact('recent_orders'));
    }

    public function processing_orders()
    {
        $couriers = Courier::all();
        $recent_orders = OrderDetails::where('status', 'shipped')->get();
        return view('admin.processing_orders', compact('recent_orders', 'couriers'));
    }

    public function delivered_orders()
    {
        $recent_orders = OrderDetails::where('status', 'delivered')->get();
        return view('admin.delivered_orders', compact('recent_orders'));
    }





    public function view_recent_orders($order_random_id)
    {

        $recent_orders = OrderDetails::with(['product.category', 'product.subcategory'])
            ->where('order_random_id', $order_random_id)
            ->where('status', 'pending')
            ->get();

        return view('admin.view_recent_orders', compact('recent_orders'));
    }



    public function view_delivered_orders($order_random_id)
    {
        $recent_orders = OrderDetails::where('order_random_id', $order_random_id)
            ->where('status', 'delivered')
            ->get();
        return view('admin.view_delivery_orders', compact('recent_orders'));
    }

    public function view_processing_orders($order_random_id)
    {
        $recent_orders = OrderDetails::where('order_random_id', $order_random_id)
            ->where('status', 'shipped')
            ->get();
        return view('admin.view_processing_orders', compact('recent_orders'));
    }
    public function view_accepted_orders($order_random_id)
    {
        $recent_orders = OrderDetails::where('order_random_id', $order_random_id)
            ->where('status', 'accepted')
            ->get();
        return view('admin.view_accepted_orders', compact('recent_orders'));
    }

    public function cancelled_orders()
    {
        $cancelled_orders = OrderDetails::where('status', 'cancelled')->get();

        return view('admin.cancelled_order', compact('cancelled_orders'));
    }
    public function view_cancel_orders($order_random_id)
    {

        $cancelled_order = OrderDetails::where('order_random_id', $order_random_id)
            ->where('status', 'cancelled')
            ->get();

        return view('admin.view_cancel_orders', compact('cancelled_order'));
    }
    public function dashboard()
    {
        // Retrieve counts
        $userCount = User::where('role', 'user')->count();
        $acceptedOrderCount = OrderDetails::where('status', 'accepted')->count();
        $shippedOrderCount = OrderDetails::where('status', 'shipped')->count();
        $recentOrderCount = OrderDetails::where('status', 'pending')->count();
        $deliveredOrderCount = OrderDetails::where('status', 'delivered')->count();
        $cancelledOrderCount = OrderDetails::where('status', 'cancelled')->count();

        // Pass all data to the view
        return view('admin.dashboard', compact('userCount', 'acceptedOrderCount', 'shippedOrderCount', 'recentOrderCount', 'deliveredOrderCount', 'cancelledOrderCount'));
    }
    
}
