<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class WishlistResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        return [
            'id'                  => $this->id,
            'user_id'             => $this->user_id,
            'product_id'          => $this->product_id,
            'product_name'        => $this->product->title,
            'product_description' => $this->product->description,
            'product_image'       => $this->product->image,
            'product_price'       => $this->product->variants->first()->price ?? null,    // Fetch the price from the first variant
            'product_variants'    => $this->product->variants->map(function ($variant) {
                return [
                    'id'          => $variant->id,
                    'title'       => $variant->title,
                    'price'       => $variant->price,
                    'description' => $variant->description,
                    'discount'    => $variant->discount,
                ];
            }),
            'is_wishlist'         => $this->product->is_wishlist ?? false,  
        ];
    }
}
