<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasFactory, Notifiable, HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'user_id',
        'email',
        'password',
        'phone_number',
        'is_active',
        'role',
        'house_no',
        'building_name',
        'road_name',
        'landmark',
        'district',
        'state',
        'pin',
        'forgot_token',
        'profile_image',
        'otp',
        'otp_expires_at',
        'is_verfied',

    ];


   

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'password' => 'hashed',
        ];
    }

    public function orderDetails()
    {
        return $this->hasOne(OrderDetails::class);
    }
    
    public function addresses()
    {
        return $this->hasMany(Address::class);
    }
    
    public function currentAddress()
    {
        return $this->hasOne(Address::class)->where('is_current', true);
    }
}
