<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('town_id')->nullable()->constrained('delivery_fee_masters')->onDelete('cascade');
            $table->string('category_name')->nullable();
            $table->string('subcategory_name')->nullable();
            $table->foreignId('link_to')->nullable()->constrained('categories')->onDelete('cascade');
            $table->string('category_img')->nullable();
            $table->enum('category_type', ['1', '2']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
