@extends('admin.layouts')
@section('title', 'Recent Orders')
@section('header')

    <!-- DataTable CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/datatable/buttons.dataTables.min.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')



    <div class="container-fluid page-wrapper">

        <div class="row">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="page-top-heading">View processing Orders</h3>
            </div>
        </div>

        <!-- Table Row -->
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="card datatable-card">
                    <div class="card-body">
        <table id="data-table" class="table nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S/N</th>
                                    <th>ORDER DATE</th>
                                    <th>BILL ID</th>
                                    <th>USER DETAILS</th>

                                    <th>PRODUCT DETAILS</th>
                                    <th>AMOUNT</th>
                                    <th>ADDRESS</th>
                                    <th>INSTRUCTION</th>
                                   
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($recent_orders as $recent_order)
                                    <tr>

                                        <td>{{ $loop->iteration }}</td>
                                      
                                        <td>{{ \Carbon\Carbon::parse($recent_order->order_date)->format('d-m-Y') }}</td>
                                        <td class="custom-td">{{ $recent_order->order_random_id}}</td>
                                        <td>
                                            <div>{{ $recent_order->user_name }}</div>
                                                <div>{{ $recent_order->user->phone_number }}</div>
                                                <div>{{ $recent_order->user->email}}</div>
                                        </td>
                                        <td>
                                            <p>Product Name:{{ $recent_order->product_details_name ?? 'N/A' }}</p>
                                            <p>Category:{{ $recent_order->category_name ?? 'N/A' }} </p>
                                            <p>SubCategory:{{ $recent_order->subcategory_name ?? 'N/A' }}</p>
                                        </td>
                                      
                                      
                                        <td><span>{{ $recent_order->amount }}</span></td>
                                        <td class="custom-td">{{ $recent_order->delivery_address }}</td>
                                        <td class="custom-td">{{ $recent_order->instruction }}</td>
                                    </td>
                                    </tr>
                                @endforeach
                            </tbody>


        </table>

                    </div>
                </div>
            </div>
        </div>
        <!-- Table Row Ends -->


      

    </div>
    <!-- end container fluid -->




@endsection
@section('footer')


    <!-- JQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!-- Datatable JS -->
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/datatables.init.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.html5.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/buttons.print.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/jszip.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/pdfmake.min.js"></script>
    <script type="text/javascript" src="{{ asset('/assets') }}/js/datatable/vfs_fonts.js"></script>



@endsection
