<?php

use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ForgetPasswordController;
use App\Http\Controllers\Admin\LoginController;
use App\Http\Controllers\Admin\OrderController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\AdminController;

Route::get('/migrate', function () {
    Artisan::call('migrate');
});
Route::get('/initial-run', function () {
    Artisan::call('db:seed');
});
Route::get('/clear-cache', function () {
    Artisan::call('optimize');
});
Route::get('/clear-all-cache', function () {
    Artisan::call('optimize:clear');
});
Route::get('/fresh-database', function () {
    Artisan::call('migrate:fresh');
});
Route::get('/', function () {
    return view('welcome');
});
// Completed 
Route::prefix('admin')->group(function () {

    //login
    Route::get('/', [AdminController::class, 'login'])->name('admin.login');
    // Route::post('/login', [LoginController::class, 'handle'])->name('login.handle');
    Route::post('login_sendotp', [LoginController::class, 'login_sendotp'])->name('login_sendotp');
    Route::post('login_verifyotp', [LoginController::class, 'login_verifyotp'])->name('login_verifyotp');

    
    //forgetpassword
    Route::get('forgot_password', [AdminController::class, 'forgot_password'])->name('forgot_password');
    Route::post('forgot_password', [ForgetPasswordController::class, 'handle'])->name('forgotpassword.handle');
   
    //admin
    Route::get('create_password/{email}', [AdminController::class, 'create_password'])->name('create_password');
    Route::post('reset_password_update', [ForgetPasswordController::class, 'reset_password_update'])->name('reset_password_update');
   
    //user
    Route::get('user_create_password/{email}/{id}', [AdminController::class, 'user_create_password'])->name('user_create_password');
    Route::post('forget_update', [ForgetPasswordController::class, 'forget_update'])->name('forget_update');
    Route::get('sucess_password', [AdminController::class, 'sucess_password'])->name('admin.sucess_password');

 
    Route::middleware(['adminauth'])->group(function () {
        //dashboard
        Route::get('dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
        //logout
        Route::post('logout', [LoginController::class, 'logout'])->name('logout');
        //reset_password
        Route::get('reset_password', [AdminController::class, 'reset_password'])->name('reset_password');
        Route::post('reset_password_handle', [LoginController::class, 'reset_password_handle'])->name('reset_password_handle');
        //notification
        Route::get('notification', [AdminController::class, 'notification'])->name('notification');
        Route::post('notification_post', [DashboardController::class, 'notification_post'])->name('notification_post');
        Route::get('notification_delete/{id}', [DashboardController::class, 'notification_delete'])->name('notification_delete');
        //banner
        Route::get('banner', [AdminController::class, 'banner'])->name('banner');
        Route::post('banner_post', [DashboardController::class, 'banner_post'])->name('banner_post');
        Route::get('banner_delete/{id}', [DashboardController::class, 'banner_delete'])->name('banner_delete');
        //deliver_fee
        Route::get('delivery_fee', [AdminController::class, 'delivery_fee'])->name('delivery_fee');
        Route::post('delivery_fee_post', [DashboardController::class, 'delivery_fee_post'])->name('delivery_fee_post');
        Route::get('delivery_fee_delete/{id}', [DashboardController::class, 'delivery_fee_delete'])->name('delivery_fee_delete');
        //category
        Route::get('category', [AdminController::class, 'category'])->name('category');
        Route::get('add_category', [AdminController::class, 'add_category'])->name('add_category');
        Route::post('add_category_post', [CategoryController::class, 'add_category_post'])->name('add_category_post');
        Route::get('category_delete/{id}', [CategoryController::class, 'category_delete'])->name('category_delete');
        //user_management
        Route::get('user_management', [AdminController::class, 'user_management'])->name('user_management');
        //product
        Route::get('products', [AdminController::class, 'products'])->name('products');
        Route::get('add_product', [AdminController::class, 'add_product'])->name('add_product');
        Route::post('store_product', [CategoryController::class, 'store_product'])->name('store_product');
        Route::get('view_product/{id}', [AdminController::class, 'view_product'])->name('view_product');
        Route::post('update_product/{id}', [CategoryController::class, 'update_product'])->name('update_product');
        Route::get('delete_product/{id}', [CategoryController::class, 'delete_product'])->name('delete_product');
        //subcategories
        Route::get('getSubcategories', [CategoryController::class, 'getSubcategories'])->name('getSubcategories');
        //recent_orders
        Route::get('recent_orders', [AdminController::class, 'recent_orders'])->name('recent_orders');
        Route::post('accept_order', [OrderController::class, 'accept_order'])->name('accept_order');
        // Route::post('order_decline', [OrderController::class, 'declineOrder'])->name('decline_order');
      
        //accepted_orders
        Route::get('accepted_orders', [AdminController::class, 'accepted_orders'])->name('accepted_orders');
        Route::post('ship_order', [OrderController::class, 'ship_order'])->name('ship_order');
        //shippedorders
        Route::get('processing_orders', [AdminController::class, 'processing_orders'])->name('processing_orders');
        Route::post('confirm_delivery', [OrderController::class, 'confirm_delivery'])->name('confirm_delivery');
        //delivered_orders
        Route::get('delivered_orders', [AdminController::class, 'delivered_orders'])->name('delivered_orders');
        //profile
        Route::get('profile', [AdminController::class, 'profile'])->name('profile');
        Route::post('profile_update', [LoginController::class, 'profile_update'])->name('profile_update');
        //view_orders
        Route::get('view_orders/{id}', [AdminController::class, 'view_orders'])->name('view_orders');
        //delivery_post_pricefrom 
        Route::get('delivery_price_page', [DashboardController::class, 'delivery_price_page'])->name('delivery_price_page');
        Route::post('delivery_post', [DashboardController::class, 'delivery_post'])->name('delivery_post');
        //viewing_orders
        Route::get('view_recent_orders/{order_random_id}', [AdminController::class, 'view_recent_orders'])->name('view_recent_orders');
        Route::get('view_delivered_orders/{order_random_id}', [AdminController::class, 'view_delivered_orders'])->name('view_delivered_orders');
        Route::get('view_processing_orders/{order_random_id}', [AdminController::class, 'view_processing_orders'])->name('view_processing_orders');
        Route::get('view_accepted_orders/{order_random_id}', [AdminController::class, 'view_accepted_orders'])->name('view_accepted_orders');
        Route::post('decline_order', [OrderController::class, 'decline_order'])->name('decline_order');
        Route::get('cancelled_orders', [AdminController::class, 'cancelled_orders'])->name('cancelled_orders');
        Route::get('view_cancel_orders/{order_random_id}', [AdminController::class, 'view_cancel_orders'])->name('view_cancel_orders');
       
    });
});


