<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Mail\RegistrationOtpMail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Models\User; 
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class RegisterController extends Controller
{
   
    public function registration_post(Request $request)
    {
        Log::info('Received request for registration.', $request->all());
        $validator = Validator::make($request->all(), [
            'name'           => 'required|string|max:255',
            'email'          => 'required|email|unique:users,email',
            'phone_number'   => 'required|string|max:10|unique:users,phone_number',
            'password'       => 'required|string|min:8|confirmed',
        ], [
            'email.unique'        => 'The email is already registered.',
            'phone_number.unique' => 'The phone number already exists.',
        ]);
        
    
        if ($validator->fails()) {
            Log::error('Validation errors:', $validator->errors()->toArray());
            return response()->json([
                'status'  => 'error',
                'data'    => null,
                'message' => 'Validation errors',
                'code'    => 422,
                'errors'  => $validator->errors()
            ], 422);
        }
    
     
        do {
            $letters = Str::random(2);
            $numbers = str_pad(mt_rand(1, 99999), 5, '0', STR_PAD_LEFT);
            $randomId = strtoupper($letters . $numbers);
        } while (User::where('user_id', $randomId)->exists());
    
        
        $user               = new User();
        $user->name         = $request->name;
        $user->email        = $request->email;
        $user->phone_number = $request->phone_number;
        $user->password     = Hash::make($request->password);
        $user->user_id      = $randomId;
        $user->save();
    
        Log::info('User registered successfully:', $user->toArray());
    
        return response()->json([
            'status'  => 'success',
            'message' => 'User registered successfully!',
            'code'    => 200,
        ], 200);
    }
    


} 