@extends('admin.layouts')
@section('title', 'Add Category')
@section('header')
    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/formILY.css') }}">
@endsection

@section('content')
    <div class="container-fluid page-wrapper category-container">
        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">Add Category</h3>
            </div>
        </div>

        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header d-none">
                        <h5 class="card-title">Add Category</h5>
                    </div>
                    <div class="card-body">
                      
                        <form action="{{ route('add_category_post') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">
                                    <!-- Image Upload -->
                                    <div class="form-group mb-3">
                                        <label for="category_img" class="form-label">Choose Image</label>
                                        <input class="form-control" name="category_img" type="file" id="category_img" accept="image/*">
                                        @error('category_img')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                        
                                    <!-- Category Type Selection -->
                                    <div class="form-group mb-3">
                                        <label for="category_type" class="form-label">Select Category Type</label>
                                        <select class="form-select" name="category_type" id="category_type" aria-label="Category Type Select">
                                            <option value="">Select</option>
                                            <option value="1" {{ old('category_type') == '1' ? 'selected' : '' }}>Category</option>
                                            <option value="2" {{ old('category_type') == '2' ? 'selected' : '' }}>SubCategory</option>
                                        </select>
                                        @error('category_type')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                        
                                    <!-- Category Name -->
                                    <div class="form-group mb-3" id="category_name_group">
                                        <label for="category_name" class="form-label">Category Name</label>
                                        <input type="text" name="category_name" class="form-control" id="category_name" placeholder="Enter Name" value="{{ old('category_name') }}">
                                        @error('category_name')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                        
                                    <!-- Subcategory Name -->
                                    <div class="form-group mb-3" id="subcategory_name_group">
                                        <label for="subcategory_name" class="form-label">Subcategory Name</label>
                                        <input type="text" name="subcategory_name" class="form-control" id="subcategory_name" placeholder="Enter Name" value="{{ old('subcategory_name') }}">
                                        @error('subcategory_name')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                        
                                    <!-- Link To Category -->
                                    <div class="form-group mb-3" id="link_to_category" style="display: none;">
                                        <label for="link_to" class="form-label">If Type Sub Category Then Link To</label>
                                        <select class="form-select" name="link_to" id="link_to" aria-label="Link To Select">
                                            <option value="">Select Category to Link</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}" {{ old('link_to') == $category->id ? 'selected' : '' }}>
                                                    {{ $category->category_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('link_to')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                        
                                    <!-- Submit Button -->
                                    <div class="button-container mt-4">
                                        <button type="submit" class="btn btn-primary submit-btn">
                                            <i class="fa-regular fa-circle-check me-2"></i>Submit
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        
                        
                    </div>
                </div>
            </div>
        </div>
        <!-- Row Ends.. -->
    </div>
    <!-- end container fluid -->
@endsection
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const categoryTypeSelect = document.getElementById('category_type');
        const linkToCategoryDiv = document.getElementById('link_to_category');
        const categoryNameGroup = document.getElementById('category_name_group');
        const subcategoryNameGroup = document.getElementById('subcategory_name_group');
    
        function handleCategoryTypeChange() {
            const selectedType = categoryTypeSelect.value;
    
            if (selectedType === '2') {
                // Show subcategory fields and link-to selection
                linkToCategoryDiv.style.display = 'block';
                categoryNameGroup.style.display = 'none';
                subcategoryNameGroup.style.display = 'block';
            } else {
                // Show category fields and hide subcategory and link-to selection
                linkToCategoryDiv.style.display = 'none';
                categoryNameGroup.style.display = 'block';
                subcategoryNameGroup.style.display = 'none';
            }
        }
    
        categoryTypeSelect.addEventListener('change', handleCategoryTypeChange);
    
        // Initialize form fields based on the current selected value
        handleCategoryTypeChange();
    });
    </script>
    
@section('footer')

@endsection
